/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/

/* ---------------------------------------------------------------
 * File: xversion.h 
 * -----------------------------------------------------------------*/

#ifndef XVERSION_H_STRING_INCLUDED
#define XVERSION_H_STRING_INCLUDED

/* 
  BEST VERSIONING
  
  Be careful, if you change one of the following numbers !!
  They are compared against each other during Firmware 
  update, when BestXOpen() is called and when the GUI is launched. 
  They allow exchanging single parts of the software while
  maintaining consistency between them. 
  On the other hand errors will be generated, when using parts
  which do not fit together.

  Be aware that these numbers exist (maybe different !) in:
  - the executable
  - each dll
  - the Core- and the Bios- image on card
  - bios_hex.mot and core_hex.mot

  For an explanation of the various dependencies see
  chris's lab book page 269.
*/

/* This is the overall version for PCI,PCIX and SVP alltogether.
   It is used for labelling and for Linux dll versioning.
   It is not used and not accessible per API */
#define BX_VER_BEST     BEST_3.0.0

#define BX_VER_GUI      3,0,2,0     
#define BX_VER_PPRX     3,0,0,8
#define BX_VER_CAPI     3,0,2,0

/* These are the versions for PCIX firmware */
#define BX_VER_BIOS     3,0,0,1
#define BX_VER_CORE     3,0,0,0    

/* These are the versions for PCI2X firmware */
#define BX_VER_BIOS2X   0,0,1,6
#define BX_VER_CORE2X   0,0,0,4 

/* Version of USB client driver.
   This is only 16 (instead of 32) bit.
   So higher numbers must always be zero (format: 0,0,n,m),
   i.e. no Major/Minor version number.
   Used in firmcore/usbenum.c
*/
#define BX_VER_USBD     0,0,3,0  /* 0,0,n,m means version n.m */

#ifdef LINUX
#define BX_STR(a,b,c,d) "a,b,c,d"
#else
#define BX_STR(s) #s
#endif

#define BX_STRINGIZE(m) BX_STR(m)

/* Strings of the version numbers. Used in .rc files*/
#define BX_VER_GUI_STRING    BX_STRINGIZE(BX_VER_GUI)
#define BX_VER_CAPI_STRING   BX_STRINGIZE(BX_VER_CAPI)
#define BX_VER_PPRX_STRING   BX_STRINGIZE(BX_VER_PPRX)
#define BX_VER_BIOS_STRING   BX_STRINGIZE(BX_VER_BIOS)
#define BX_VER_CORE_STRING   BX_STRINGIZE(BX_VER_CORE)
#define BX_VER_BIOS2X_STRING BX_STRINGIZE(BX_VER_BIOS2X)
#define BX_VER_CORE2X_STRING BX_STRINGIZE(BX_VER_CORE2X)

extern const char * version_string;  /* this is for gui only */
extern const char * link_date_string;

#endif
